<?php

namespace App\Http\Controllers;

use App\Http\Requests\Assistance\AssistanceRequest;
use App\Services\AssistanceService;
use App\Services\UploadFileService;


class AssistanceController extends Controller
{
    //create assistance
    public function store(AssistanceRequest $request)
    {
        $file = $request->file('file');
        $fileExtension = $file->getClientOriginalExtension();
        $route = "";

        if ($fileExtension === "pdf") {
            $route = "assistance/files";
        } else if (in_array($fileExtension, array('png', 'jpg', 'jpeg'))) {
            $route = "images/assistance";
        }
        $objFile = [
            'file' => $file,
            'nameFile' => time(),
            'route' => $route,
        ];

        $uploadService = new UploadFileService();
        $resultUploadService = $uploadService->upload($objFile);


        $objAssistance = [
            'diplomatic' => $request->diplomatic,
            'affair' => $request->affair,
            'content' => $request->content,
            'country_id' => $request->country_id,
            'file' => $resultUploadService['pathUrl']
        ];

        $assistanceService = new AssistanceService();
        $assistance = $assistanceService->create($objAssistance);

        return $assistance;
    }
}
