<?php

namespace App\Http\Controllers;

use App\Http\Requests\User\UserLoginRequest;
use App\Http\Requests\User\UserRequest;
use App\Services\UserService;
use Exception;
use Symfony\Component\HttpFoundation\Response;
use Tymon\JWTAuth\Facades\JWTAuth;

class AuthController extends Controller
{
    //register account user
    public function register(UserRequest $request)
    {

        $userService = new UserService();
        $objUser = [
            'dni' => $request->dni,
            'names' => $request->names,
            'birthDate' => $request->birthDate,
            'country_id' => $request->countryId,
            'address' => $request->address,
            'email' => $request->email,
            'phone' => $request->phone,
            'password' => $request->password,
            'roles' => $request->roles
        ];

        $user = $userService->create($objUser);

        $token = JWTAuth::fromUser($user);
        return $this->respondWithToken($token);
    }


    //auth of user
    public function login(UserLoginRequest $request)
    {

        $credentials = $request->only('email', 'password');
        if (!$token = auth()->attempt($credentials)) {
            throw new Exception("Credenciales inválidas", Response::HTTP_UNAUTHORIZED);
        }

        return $this->respondWithToken($token);
    }


    //logout
    public function logout()
    {


        auth()->logout();

        return response()->json(
            [
                'message' => 'Sesión cerrada satisfactoriamente',
                'status' => 'success'
            ],
            Response::HTTP_ACCEPTED
        );
    }

    //response jwt
    protected function respondWithToken($token)
    {
        return response()->json([
            'message' => 'Autenticado',
            'status' => 'success',
            'access_token' => $token,
            'token_type' => 'bearer',
            'expires_in' => auth()->factory()->getTTL() * 60
        ]);
    }
}
