<?php

namespace App\Http\Controllers;

use App\Http\Requests\Country\CountryRequest;
use App\Services\CountryService;
use App\Services\UploadFileService;


class CountryController extends Controller
{

    //get all countries
    public function index()
    {
        $countryService = new CountryService();
        $countries = $countryService->getAll();

        return response()->json($countries);
    }

    //get country with procedures
    public function show($id)
    {
        $countryService = new CountryService();
        $country = $countryService->getById($id);

        return response()->json($country);
    }

    //crate country
    public function store(CountryRequest $request)
    {
        $objFile = [
            'file' => $request->file('file'),
            'name' => $request->country,
            'urlFile' => 'images/countries/flags',
        ];
        $uploadFileService = new UploadFileService();
        $resultFileService = $uploadFileService->upload($objFile);


        $objCountry = [
            'country' => $request->country,
            'urlFile' => $resultFileService['urlFile']
        ];
        $countryService = new CountryService();
        $country = $countryService->create($objCountry);


        return response()->json($country);
    }
}
