<?php

namespace App\Http\Controllers;

use App\Http\Requests\News\NewsRequest;
use App\Services\NewsService;
use App\Services\UploadFileService;

class NewsController extends Controller
{
    //get all news
    public function index()
    {
        $newsService = new NewsService();
        $news = $newsService->getAll();

        return $news;
    }

    //create news
    public function store(NewsRequest $request)
    {
        $objFile = [
            'file' => $request->file('file'),
            'name' => time(),
            'urlFile' => 'images/news',
        ];

        $uploadFileService = new UploadFileService();
        $urlFile = $uploadFileService->upload($objFile);

        $objNews = [
            'title' => $request->title,
            'description' => $request->description,
            'urlFile' => $urlFile,
            'createDate' => $request->createDate,
        ];

        $newsService = new NewsService();
        $news = $newsService->create($objNews);

        return $news;
    }
}
