<?php

namespace App\Http\Controllers;

use App\Http\Requests\Procedure\ProcedureRequest;
use App\Services\ProcedureService;
use Exception;


class ProcedureController extends Controller
{
    //get all procedures
    public function index()
    {
        try {

            $procedureService = new ProcedureService();
            $procedures = $procedureService->getAll();

            return response()->json($procedures);
        } catch (Exception $e) {
            return response()->json([
                'message' => $e->getMessage(),
                'status' => 'error',
            ], $e->getCode());
        }
    }


    //crate procedure
    public function store(ProcedureRequest $request)
    {
        $objProcedure = [
            'id' => 0,
            'procedure' => $request['procedure'],
            'user_id' => $request['user_id'],
            'country_id' => $request['country_id'],
        ];

        $procedureService = new ProcedureService();
        $procedure = $procedureService->crate($objProcedure);

        return response()->json($procedure);
    }
}
