<?php

namespace App\Http\Middleware;

use Closure;
use Exception;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class AdminMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {


        if (auth()->user()->isAdmin) {
            return $next($request);
        }
        return response()->json([
            'message' => 'No autorizado',
            'status' => 'error'
        ], Response::HTTP_UNAUTHORIZED);
    }
}
