<?php

namespace App\Http\Middleware;

use App\Exceptions\ErrorHandleException;
use Closure;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Http\Response as HttpResponse;
use Symfony\Component\HttpFoundation\Response;
use Tymon\JWTAuth\Exceptions\TokenExpiredException;
use Tymon\JWTAuth\Exceptions\TokenInvalidException;
use Tymon\JWTAuth\Facades\JWTAuth;

class JwtMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        try {


            if (!auth()->check()) {
                return response()->json([
                    'message' => 'No autenticado',
                    'status' => 'error'
                ], Response::HTTP_UNAUTHORIZED);
            }
            JWTAuth::parseToken()->authenticate();
        } catch (Exception $e) {
            if ($e instanceof TokenInvalidException) {

                return response()->json([
                    'message' => 'Token invalido',
                    'status' => 'error'
                ], HttpResponse::HTTP_UNAUTHORIZED);
            }
            if ($e instanceof TokenExpiredException) {
                return response()->json([
                    'message' => 'Token expirado',
                    'status' => 'error'
                ], HttpResponse::HTTP_UNAUTHORIZED);
            }

            return response()->json([
                'message' => 'No autorizado',
                'status' => 'error'
            ], HttpResponse::HTTP_UNAUTHORIZED);
        }
        return $next($request);
    }
}
