<?php

namespace App\Http\Requests\Assistance;

use Illuminate\Foundation\Http\FormRequest;

class AssistanceRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {

        return [
            'diplomatic' => 'required|max:50',
            'affair' => 'required|string|max:500',
            'country_id' => 'required|numeric',
            'content' => 'required|string|max:65534',
            'file' => 'required|file|mimes:jpeg,png,jpg,pdf',
        ];
    }
}
