<?php

namespace App\Http\Requests\user;

use Illuminate\Foundation\Http\FormRequest;

class UserRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'dni' => 'required|string|max:10|unique:users',
            'names' => 'required|string|max:150',
            'birthDate' => 'required|string',
            'countryId' => 'required|numeric',
            'address' => 'required|string|max:150',
            'email' => 'required|email|max:150|unique:users',
            'phone' => 'required|string|max:10|',
            'password' => 'required|max:15|min:8',
            'roles' => 'required|array'
        ];
    }
}
