<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Country extends Model
{
    use HasFactory;

    public $timestamps = false;

    protected $table = 'countries';
    protected $fillable = [
        'country',
        'urlFile',
        'state'
    ];

    public function procedures()
    {
        return $this->belongsToMany(Procedure::class, 'procedures_countries');
    }

    public function users()
    {
        return $this->hasMany(User::class);
    }
}
