<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Procedure extends Model
{
    use HasFactory;

    protected $table = 'procedures';
    protected $fillable = [
        'procedure',
        'state',
        'user_id'
    ];

    public function user()
    {
        $objProcedure = $this->belongsTo(User::class)->where('state', '=', 1);
        return $objProcedure;
    }

    public function countries()
    {
        $objProcedure = $this->belongsToMany(Country::class, 'procedures_countries')
            ->where('state', '=', 1);
        return $objProcedure;
    }
}
