<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Role extends Model
{
    use HasFactory;

    public $timestamps = false;

    protected $table = 'roles';
    protected $fillable = [
        'role',
        'name',
        'state'
    ];


    public function users()
    {
        return $this->belongsToMany(User::class, 'users_roles');
    }
}
