<?php


namespace App\Services;

use App\Models\Assistance;
use Exception;
use Illuminate\Http\Response;

class AssistanceService
{

    public function create($objAssistance)
    {
        if ($this->validate($objAssistance)) {

            $assistance = Assistance::create([
                'diplomatic' => $objAssistance['diplomatic'],
                'affair' => $objAssistance['affair'],
                'content' => $objAssistance['content'],
                'country_id' => $objAssistance['country_id'],
                'file' => $objAssistance['file']
            ]);

            $objReturn = [
                'data' => $assistance,
                'message' => 'Reclamo registrado satisfactoriamente',
                'status' => 'success'
            ];

            return $objReturn;
        }
    }

    private function validate($objAssistance)
    {
        if (!is_array($objAssistance)) {
            $this->exceptionError('array de parámetros');
        }
        if ($objAssistance['diplomatic'] === '') {
            $this->exceptionError('reprecentación diplomática');
        } else
        if ($objAssistance['country_id'] === '') {
            $this->exceptionError('país');
        } else
        if ($objAssistance['affair'] === '') {
            $this->exceptionError('asunto');
        } else
        if ($objAssistance['content'] === '') {
            $this->exceptionError('contenido');
        } else {

            return true;
        }
    }

    private function exceptionError($field)
    {
        throw new Exception('El campo ' . $field . ' es requerido', Response::HTTP_BAD_REQUEST);
    }
}
