<?php

namespace App\Services;

use App\Models\Country;
use Exception;
use Illuminate\Http\Response;

class CountryService
{
    //get all countries
    public function getAll()
    {
        $countries = Country::where('state', '=', 1)->get();
        return $countries;
    }

    //get country with procedures
    public function getById($countryId)
    {
        if (!$countryId) {
            $this->exceptionError('parámetro id');
        }

        $country = Country::find($countryId);
        if (!$country) {
            throw new Exception('País no existe', Response::HTTP_NOT_FOUND);
        }

        if ($country->state == 0) {
            throw new Exception('País no existe', Response::HTTP_NOT_FOUND);
        }

        $country->procedures;

        return $country;
    }


    //create country
    public function create($objCountry)
    {
        if ($this->validate($objCountry)) {

            $country = Country::create([
                'country' => $objCountry['country'],
                'urlFile' => $objCountry['urlFile'],
                'state' => true
            ]);
            return $country;
        }
    }


    private function validate($objCountry)
    {
        if (!is_array($objCountry)) {
            $this->exceptionError('array de parámetros');
        }
        if ($objCountry['country'] == '') {
            $this->exceptionError('campo país');
        } else
        if ($objCountry['urlFile'] == '') {
            $this->exceptionError('campo url');
        } else {
            return true;
        }
    }

    private function exceptionError($field)
    {
        throw new Exception('El ' . $field . ' es requerido', Response::HTTP_BAD_REQUEST);
    }
}
