<?php

namespace App\Services;

use App\Models\News;
use Exception;
use Illuminate\Http\Response;

class NewsService
{
    //get all news
    public function getAll()
    {
        $news = News::where('state', '=', 1)->get();
        return $news;
    }

    //create news
    public function create($objNews)
    {

        if ($this->validate($objNews)) {

            $news = News::create([
                'title' => $objNews['title'],
                'description' => $objNews['description'],
                'urlFile' => $objNews['urlFile'],
                'createDate' => $objNews['createDate'] = date('Y-m-d'),
                'state' => true
            ]);

            return $news;
        }
    }

    private function validate($objCountry)
    {
        if (!is_array($objCountry)) {
            $this->exceptionError('array de parámetros');
        }
        if ($objCountry['title'] == "") {
            $this->exceptionError('campo título');
        } else if ($objCountry['description'] == "") {
            $this->exceptionError('campo descripción');
        } else if ($objCountry['createDate'] == "") {
            $this->exceptionError('campo fecha creación');
        } else if ($objCountry['urlFile'] == "") {
            $this->exceptionError('campo url');
        } else {
            return true;
        }
    }

    private function exceptionError($field)
    {
        throw new Exception('El ' . $field . ' es requerido', Response::HTTP_BAD_REQUEST);
    }
}
