<?php

namespace App\Services;


use App\Models\Procedure;
use App\Models\ProcedureCountry;
use Exception;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;

class ProcedureService
{
    //get all procedures
    public function getAll()
    {
        $procedures = Procedure::where('state', '=', 1)->get();
        return $procedures;
    }

    public function crate($objProcedure)
    {
        try {

            DB::beginTransaction();

            if ($this->validate($objProcedure)) {

                $procedure = Procedure::create([
                    'procedure' => $objProcedure['procedure'],
                    'user_id' => $objProcedure['user_id'],
                    'state' => true
                ]);

                foreach ($objProcedure['country_id'] as $country_id) {
                    ProcedureCountry::create([
                        'procedure_id' => $procedure->id,
                        'country_id' => $country_id
                    ]);
                }

                DB::commit();

                return $procedure;
            }
        } catch (Exception $e) {
            DB::rollBack();
            throw new Exception($e->getMessage(), Response::HTTP_CONFLICT);
        }
    }


    private function validate($objProcedure)
    {
        if (!is_array($objProcedure)) {
            $this->exceptionError('array de parámetros');
        }
        if ($objProcedure['procedure'] == "") {
            $this->exceptionError('campo contraseña');
        }
        if ($objProcedure['user_id'] == null) {
            $this->exceptionError('campo contraseña');
        }
        if (!is_array($objProcedure['country_id']) || count($objProcedure['country_id']) == 0) {
            $this->exceptionError('campo contraseña');
        }

        return true;
    }

    private function exceptionError($field)
    {
        throw new Exception('El ' . $field . ' es requerido', Response::HTTP_BAD_REQUEST);
    }
}
