<?php

namespace App\Services;

use App\Models\Role;
use Exception;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Config;

class ProviderDNIService
{
    public function getNamesDNI($dni)
    {

        if (!$dni) {
            throw new Exception("El parámetro cédula es requerido", Response::HTTP_CONFLICT);
        }

        $apiKey = Config::get('app.DNI_URL');
        $url = $apiKey . '/' . $dni;

        $response = Http::get($url);
        $result = json_decode($response->body());

        if (!$result) {

            $arrayReturn = [
                'dni'  => '',
                'names' => ''
            ];
            return $arrayReturn;
        }

        $arrayReturn = [
            'dni'  => $result->identificacion,
            'names' => $result->nombreCompleto
        ];

        return $arrayReturn;
    }
}
