<?php

namespace App\Services;

use Exception;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Storage;


class UploadFileService
{

    public function upload($objFile)
    {

        if ($this->validate($objFile)) {

            $fileExtension = $objFile['file']->getClientOriginalExtension();
            $file = $objFile['name'] . '.' . $fileExtension;

            //in_array($fileExtension, array('png','jpg', 'jpeg'))

            $url = $objFile['file']->storeAs("public/{$objFile['urlFile']}", $file);
            $urlFile = Storage::url($url);

            return $urlFile;
        }
    }

    private function validate($objFile)
    {
        if (!is_array($objFile)) {
            $this->exceptionError('array de parámetros');
        }
        if ($objFile['file'] == null | $objFile['file'] == "") {
            $this->exceptionError('archivo');
        } else if ($objFile['name'] == "") {
            $this->exceptionError('nombre del archivo');
        } else if ($objFile['urlFile'] == "") {
            $this->exceptionError('url de la ubicación del archivo');
        } else {

            return true;
        }
    }

    private function exceptionError($field)
    {
        throw new Exception('El ' . $field . ' es requerido', Response::HTTP_BAD_REQUEST);
    }
}
