<?php

namespace App\Services;

use App\Models\User;
use App\Models\UsersRoles;
use Exception;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;


class UserService
{
    //create user and relationship roles
    public function create($objUser)
    {
        try {

            DB::beginTransaction();

            if ($this->validate($objUser)) {

                //1 ADMIN
                //2 USER
                $isAdmin = false;

                if (in_array(1, $objUser['roles'])) {
                    $isAdmin = true;
                }

                $user = User::create([
                    'dni' => $objUser['dni'],
                    'names' => $objUser['names'],
                    'birthDate' => $objUser['birthDate'] = date('Y-m-d'),
                    'country_id' => $objUser['country_id'],
                    'address' => $objUser['address'],
                    'email' => $objUser['email'],
                    'phone' => $objUser['phone'],
                    'password' => Hash::make($objUser['password']),
                    'isAdmin' => $isAdmin,
                    'state' => true
                ]);

                //register relationship user and rol
                foreach ($objUser['roles'] as $role_id) {

                    UsersRoles::create([
                        'user_id' => $user->id,
                        'role_id' => $role_id
                    ]);
                }

                DB::commit();

                return $user;
            }
        } catch (Exception $e) {
            DB::rollBack();
            throw new Exception($e->getMessage(), Response::HTTP_CONFLICT);
        }
    }

    //get names by dni
    public function getNamesByDNI($dni)
    {
        if (!$dni) {
            $this->exceptionError('parámetro cédula (dni)');
        }

        $user = User::where('dni', '=', $dni)->get();

        if (count($user) == 0) {

            $providerDNIService = new ProviderDNIService();
            $names = $providerDNIService->getNamesDNI($dni);

            return response()->json($names);
        }

        return response()->json($user[0]);
    }

    //get information user
    public function profile()
    {
        $user = auth()->user();
        $user->country;
        $user->roles;
        return response()->json($user);
    }

    //validate objUser
    private function validate($objUser)
    {
        if (!is_array($objUser)) {
            $this->exceptionError('array de parámetros');
        }
        if ($objUser['dni'] == "") {
            $this->exceptionError('campo cédula');
        }
        if ($objUser['names'] == "") {
            $this->exceptionError('campo nombres');
        }
        if ($objUser['birthDate'] == "") {
            $this->exceptionError('campo fecha nacimiento');
        }
        if ($objUser['country_id'] == "") {
            $this->exceptionError('campo país');
        }
        if ($objUser['address'] == "") {
            $this->exceptionError('campo dirección');
        }
        if ($objUser['email'] == "") {
            $this->exceptionError('campo email');
        }
        if ($objUser['phone'] == "") {
            $this->exceptionError('campo teléfono');
        }
        if ($objUser['password'] == "") {
            $this->exceptionError('campo contraseña');
        }
        if ($objUser['roles'] == "" || count($objUser['roles']) === 0) {
            $this->exceptionError('campo rol');
        } else {
            return true;
        }
    }

    //message exception
    private function exceptionError($field)
    {
        throw new Exception('El ' . $field . ' es requerido', Response::HTTP_BAD_REQUEST);
    }
}
