<?php

use App\Http\Controllers\AssistanceController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\CountryController;
use App\Http\Controllers\NewsController;
use App\Http\Controllers\ProcedureController;
use App\Http\Controllers\UserController;
use Illuminate\Support\Facades\Route;


//PUBLIC ROUTES

//authentication
Route::post('register', [AuthController::class, 'register']);
Route::post('login', [AuthController::class, 'login']);
Route::post('logout', [AuthController::class, 'logout']);
//provider
Route::get('users/providerDNI/{id}', [UserController::class, 'getNamesByDNI']);
//countries
Route::get('countries', [CountryController::class, 'index']);
//news
Route::get('news', [NewsController::class, 'index']);


//ROUTES REQUIRE AUTH
Route::middleware(['jwt.verify'])->group(function () {

    //user me
    Route::get('users/profile/me', [UserController::class, 'profile']);
    //countries
    Route::get('countries/{id}', [CountryController::class, 'show']);
    //procedures
    //Route::get('procedures', [ProcedureController::class, 'index']);
    //news
    Route::post('news', [NewsController::class, 'store']);
    //assistance
    Route::post('assistance', [AssistanceController::class, 'store']);
});

//validation endpoint with jwt amd role admin
Route::middleware(['jwt.verify', 'admin'])->group(function () {

    //countries
    Route::post('countries', [CountryController::class, 'store']);

    //procedures
    Route::post('procedures', [ProcedureController::class, 'store']);
});
